"""
Module contains agent-example fake analytics.

The tasks of this module:

    - provide fake analytics which will take any parameters and not assume cpu/gpu resource and returns some fake results

"""

from uuid import uuid4


class FakeAnalytics:
    """
    Fake analytics, which is intended only as example without real processing of anything
    """

    def __init__(self, analytics: list[dict]):
        """Initialize interval variables for fake analytics"""
        self.analytics = analytics
        self.counter = 0
        self.enabled = True

    async def events(self, frame):
        """
        Fake events generator, works every second
        - If not enabled, it will sleep until is will be enabled
        - If enabled returns some fake `events` according to the primitive algorithm
        """
        while True:
            if self.enabled:
                self.counter += 1
                if self.counter == 20:
                    print("Last fake event")
                    yield {"event": {"event_id": str(uuid4())}, "value": 100500}
                elif self.counter == 1:
                    print("First fake event")
                    yield {"event": {"event_id": str(uuid4())}, "value": 0}
                elif self.counter % 5 == 0:
                    print(f"Fake event number {self.counter // 5 + 1}")
                    yield {"event": {"event_id": str(uuid4())}, "value": self.counter // 5}
                elif self.counter > 20:
                    break
