"""
Module contains agent-example decoder.

The tasks of this module:

    - provide video-decoder which will take any parameters and returns frames

"""

import cv2


class Decoder:
    """Decoder, which is intended only as example"""

    def __init__(self, url: str, **kwargs):
        """Fake initialization"""
        self.url = url
        self.cap = cv2.VideoCapture(url)
        self.kwargs = kwargs

    async def nextFrame(self):
        """Async generator which yields frames from source"""
        try:
            while True:
                _, frame = self.cap.read()
                if frame is None:
                    break
                yield frame
        finally:
            self.cap.release()
