"""
Module contains agent-example working intervals resolver.

The tasks of this module:

    - function which calculates should analytics works at the moment or not

"""

import datetime


def isAnalyticsMustWorks(intervals: list[int]):
    """
    Check whether analytics must work at the moment based on current time and analytics working
    intervals received from video-manager
    """
    if not intervals:
        return True

    curTime = int(datetime.datetime.now(datetime.UTC).replace(tzinfo=None).timestamp())

    firstStart = intervals[0]
    if firstStart > curTime:
        return False

    lastEnd = intervals[-1]
    if lastEnd <= curTime:
        return False

    mustWorks = False
    for idx, point in enumerate(intervals):
        if curTime < point:
            mustWorks = idx % 2 == 1
            break
        if curTime == point:
            mustWorks = idx % 2 == 0
            break

    return mustWorks
