"""
Module contains agent-example execution functions.

The tasks of this module:

    - create aiohttp web-application with 1 route, startup and shutdown actions and execute it

"""

from agent import Agent
from aiohttp import web
from cli_args import getCliArgs
from ws_handler import ws_handler


def main():
    """
    - Parse cli-args
    - Create aiohttp web application server with 1 route
    - Enable startup and shutdown actions (see `agent` module for details)
    - Run web application
    """
    args = getCliArgs()
    webApp = web.Application()
    webApp.add_routes([web.get("/2/ws", ws_handler)])
    webApp.agent = Agent(port=args.port)
    webApp.on_startup.append(webApp.agent.runAsTask)
    webApp.on_shutdown.append(webApp.agent.close)

    web.run_app(webApp, port=args.port)


if __name__ == "__main__":
    main()
