"""
Module contains simple websocket subscription script example.
Warnings:
    Ensure stream is currently being processing otherwise it will raise an exception
"""

import asyncio

import websockets
from websockets import ConnectionClosedOK

WS_RESP = None
STREAM_ID = "<REPLACE_WITH_STREAM_ID_OF_INTEREST>"


async def main():
    global WS_RESP
    uri = f"ws://127.0.0.1:5555/2/ws?stream_id={STREAM_ID}&analytic_index=0"
    headers = {}
    try:
        async with websockets.connect(uri, additional_headers=headers) as websocket:
            while True:
                WS_RESP = await websocket.recv()
                print(WS_RESP)
    except ConnectionClosedOK:
        print("Events receiving complete")


if __name__ == "__main__":
    asyncio.run(main())
