"""
Module contains agent-example auxiliary structs and constants.

This is auxilary module which only contains some useful structs and constants.

"""

from enum import IntEnum

# account id for agent registration (required for video-manager)
ACCOUNT_ID = "3ee93f1d-198c-4096-9674-bd42a30c969f"
# video-manager base url
VIDEO_MANAGER_API_URL = "http://127.0.0.1:5230/2"


class StreamStatus(IntEnum):
    """
    Enum for stream status.
    """

    pending = 0
    in_progress = 1
    done = 2
    restart = 3
    failed = 4
    stop = 5
    # special status for splittable stream with different sub statuses
    unknown = 6
    handler_lost = 7
    paused = 8
